/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CheckBox;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CustomiseBackpackScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("backpacked", "textures/gui/customise_backpack.png");
    private static final Component SHOW_EFFECTS_TOOLTIP = Component.m_237115_((String)"backpacked.button.show_effects.tooltip");
    private static final Component SHOW_WITH_ELYTRA_TOOLTIP = Component.m_237115_((String)"backpacked.button.show_with_elytra.tooltip");
    private static final Component SHOW_ENCHANTMENT_GLINT = Component.m_237115_((String)"backpacked.button.show_enchantment_glint.tooltip");
    private static final Component LOCKED = Component.m_237115_((String)"backpacked.gui.locked").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private final ItemStack displayStack = new ItemStack((ItemLike)ModItems.BACKPACK.get());
    private final int windowWidth;
    private final int windowHeight;
    private int windowLeft;
    private int windowTop;
    private float windowRotationX = -35.0f;
    private float windowRotationY = 10.0f;
    private boolean windowGrabbed;
    private boolean scrollGrabbed;
    private int mouseClickedX;
    private int mouseClickedY;
    private Button resetButton;
    private Button saveButton;
    private CheckBox showEnchantmentGlintButton;
    private CheckBox showWithElytraButton;
    private CheckBox showEffectsButton;
    private String displayBackpackModel = null;
    private boolean displayShowEnchantmentGlint;
    private boolean displayShowWithElytra;
    private boolean displayShowEffects;
    private final List<BackpackModelEntry> models;
    private int scroll;
    private int animationTick;

    public CustomiseBackpackScreen(Map<ResourceLocation, Component> progressMap) {
        super((Component)Component.m_237115_((String)"backpacked.title.customise_backpack"));
        this.windowWidth = 201;
        this.windowHeight = 166;
        Comparator<BackpackModelEntry> compareUnlock = Comparator.comparing(e -> !e.backpack.isUnlocked((Player)Minecraft.m_91087_().f_91074_));
        Comparator<BackpackModelEntry> compareLabel = Comparator.comparing(e -> e.label.getString());
        List models = BackpackManager.instance().getClientBackpacks().stream().map(backpack -> new BackpackModelEntry((Backpack)backpack, progressMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toList());
        this.models = ImmutableList.copyOf(models);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.displayBackpackModel == null) {
            this.displayBackpackModel = this.getBackpackModel();
            this.displayShowEnchantmentGlint = this.getLocalBackpackProperty(ModelProperty.SHOW_GLINT);
            this.displayShowWithElytra = this.getLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA);
            this.displayShowEffects = this.getLocalBackpackProperty(ModelProperty.SHOW_EFFECTS);
        }
        this.windowLeft = (this.f_96543_ - this.windowWidth) / 2;
        this.windowTop = (this.f_96544_ - this.windowHeight) / 2;
        this.resetButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"backpacked.button.reset"), onPress -> {
            this.displayBackpackModel = (String)Config.SERVER.backpack.defaultCosmetic.get();
        }).m_252794_(this.windowLeft + 7, this.windowTop + 114).m_253046_(71, 20).m_253136_());
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"backpacked.button.save"), onPress -> Network.getPlay().sendToServer((IMessage)new MessageBackpackCosmetics(new ResourceLocation(this.displayBackpackModel), this.displayShowEnchantmentGlint, this.displayShowWithElytra, this.displayShowEffects))).m_252794_(this.windowLeft + 7, this.windowTop + 137).m_253046_(71, 20).m_253136_());
        this.showEnchantmentGlintButton = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.windowLeft + 133, this.windowTop + 6, CommonComponents.f_237098_, onPress -> {
            this.displayShowEnchantmentGlint = !this.displayShowEnchantmentGlint;
        }));
        this.showEnchantmentGlintButton.m_257544_(Tooltip.m_257550_((Component)SHOW_ENCHANTMENT_GLINT));
        this.showWithElytraButton = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.windowLeft + 160, this.windowTop + 6, CommonComponents.f_237098_, onPress -> {
            this.displayShowWithElytra = !this.displayShowWithElytra;
        }));
        this.showWithElytraButton.m_257544_(Tooltip.m_257550_((Component)SHOW_WITH_ELYTRA_TOOLTIP));
        this.showEffectsButton = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.windowLeft + 186, this.windowTop + 6, CommonComponents.f_237098_, onPress -> {
            this.displayShowEffects = !this.displayShowEffects;
        }));
        this.showEffectsButton.m_257544_(Tooltip.m_257550_((Component)SHOW_EFFECTS_TOOLTIP));
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)this.f_96541_.f_91074_);
        if (!backpack.m_41619_()) {
            this.showEnchantmentGlintButton.setChecked(BackpackLayer.canShowEnchantmentGlint(backpack));
            this.showWithElytraButton.setChecked(BackpackLayer.canRenderWithElytra(backpack));
            this.showEffectsButton.setChecked(ClientEvents.canShowBackpackEffects(backpack));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.resetButton.f_93623_ = !this.getBackpackModel().equals(Config.SERVER.backpack.defaultCosmetic.get());
        this.saveButton.f_93623_ = this.needsToSave();
    }

    private boolean needsToSave() {
        if (!this.displayBackpackModel.equals(this.getBackpackModel())) {
            return true;
        }
        if (this.getLocalBackpackProperty(ModelProperty.SHOW_EFFECTS) != this.displayShowEffects) {
            return true;
        }
        if (this.getLocalBackpackProperty(ModelProperty.SHOW_GLINT) != this.displayShowEnchantmentGlint) {
            return true;
        }
        return this.getLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA) != this.displayShowWithElytra;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        this.updateButtons();
        ++this.animationTick;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        BackpackModelEntry entry;
        int startIndex;
        this.m_280273_(graphics);
        graphics.m_280218_(GUI_TEXTURE, this.windowLeft, this.windowTop, 0, 0, this.windowWidth, this.windowHeight);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.f_96541_.f_91074_ != null) {
            graphics.m_280588_(this.windowLeft + 8, this.windowTop + 18, this.windowLeft + 77, this.windowTop + 110);
            this.renderPlayer(this.windowLeft + 42, this.windowTop + this.windowHeight / 2, mouseX, mouseY, (Player)this.f_96541_.f_91074_);
            graphics.m_280618_();
        }
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.windowLeft + 8, this.windowTop + 6, 0x404040, false);
        boolean canScroll = this.models.size() > 7;
        int scroll = (canScroll ? this.scroll : 0) + (this.scrollGrabbed ? mouseY - this.mouseClickedY : 0);
        scroll = Mth.m_14045_((int)scroll, (int)0, (int)123);
        graphics.m_280218_(GUI_TEXTURE, this.windowLeft + 181, this.windowTop + 18 + scroll, 201 + (!canScroll ? 12 : 0), 0, 12, 15);
        for (int i = startIndex = (int)((double)Math.max(0, this.models.size() - 7) * Mth.m_14008_((double)(((double)scroll + 15.0) / 123.0), (double)0.0, (double)1.0)); i < this.models.size() && i < startIndex + 7; ++i) {
            this.drawBackpackItem(graphics, this.windowLeft + 82, this.windowTop + 17 + (i - startIndex) * 20, mouseX, mouseY, partialTick, this.models.get(i));
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1 && !(entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((Player)this.f_96541_.f_91074_)) {
            graphics.m_280245_(this.f_96547_, entry.getUnlockTooltip(), mouseX, mouseY);
        }
    }

    private void drawBackpackItem(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTick, BackpackModelEntry entry) {
        boolean unlocked = entry.getBackpack().isUnlocked((Player)this.f_96541_.f_91074_);
        boolean selected = unlocked && entry.getId().equals(this.displayBackpackModel);
        boolean hovered = unlocked && !selected && ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 97, 20);
        int offset = (unlocked ? 0 : 60) + (selected ? 20 : 0) + (hovered ? 40 : 0);
        graphics.m_280218_(GUI_TEXTURE, x, y, 0, 166 + offset, 97, 20);
        int color = selected ? 4226832 : (hovered ? 0xFFFF80 : (unlocked ? 6839882 : 5119004));
        graphics.m_280614_(this.f_96547_, entry.getLabel(), x + 20, y + 6, color, false);
        CustomiseBackpackScreen.drawBackpackInGui(this.f_96541_, graphics, this.displayStack, entry.getBackpack(), x + 10, y + 10, partialTick);
    }

    public static void drawBackpackInGui(Minecraft mc, GuiGraphics graphics, ItemStack stack, Backpack backpack, int x, int y, float partialTick) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 150.0f);
        pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pose.m_85841_(16.0f, 16.0f, 16.0f);
        ModelMeta meta = BackpackManager.instance().getModelMeta(backpack);
        meta.guiDisplay().ifPresent(transform -> transform.m_111763_(false, pose));
        meta.renderer().ifPresentOrElse(renderer -> {
            BackpackRenderContext context = new BackpackRenderContext(pose, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, stack, backpack, (LivingEntity)mc.f_91074_, partialTick, mc.f_91074_.f_19797_, model -> {
                mc.m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, pose, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
                graphics.m_280262_();
            });
            pose.m_85836_();
            renderer.forEach(function -> function.apply(context));
            pose.m_85849_();
        }, () -> {
            BakedModel model = ClientServices.MODEL.getBakedModel(backpack.getBaseModel());
            mc.m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, pose, (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
            graphics.m_280262_();
        });
        pose.m_85849_();
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int displayIndex;
        int startIndex;
        int actualIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140) && (actualIndex = (startIndex = (int)((double)Math.max(0, this.models.size() - 7) * Mth.m_14008_((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0))) + (displayIndex = (mouseY - this.windowTop - 17) / 20)) >= 0 && actualIndex < this.models.size()) {
            return actualIndex;
        }
        return -1;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140)) {
            BackpackModelEntry entry;
            int hoveredIndex;
            if (button == 0 && (hoveredIndex = this.getHoveredIndex((int)mouseX, (int)mouseY)) != -1 && (entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((Player)this.f_96541_.f_91074_)) {
                this.displayBackpackModel = entry.getId();
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 8, this.windowTop + 18, 69, 92)) {
            if (!this.windowGrabbed && button == 0) {
                this.windowGrabbed = true;
                this.mouseClickedX = (int)mouseX;
                this.mouseClickedY = (int)mouseY;
                return true;
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 181, this.windowTop + 18 + this.scroll, 12, 15) && !this.scrollGrabbed && button == 0) {
            this.scrollGrabbed = true;
            this.mouseClickedY = (int)mouseY;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.windowGrabbed && button == 0) {
            this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
            this.windowRotationY = (float)((double)this.windowRotationY + (mouseY - (double)this.mouseClickedY));
            this.windowGrabbed = false;
        }
        if (this.scrollGrabbed && button == 0) {
            this.scroll = (int)((double)this.scroll + (mouseY - (double)this.mouseClickedY));
            this.scroll = Mth.m_14045_((int)this.scroll, (int)0, (int)123);
            this.scrollGrabbed = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 112, 140)) {
            int startIndex = (int)((double)Math.max(0, this.models.size() - 7) * Mth.m_14008_((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0));
            int newIndex = startIndex - (int)Math.signum(scroll);
            this.scrollToIndex(newIndex);
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    private void scrollToIndex(int index) {
        this.scroll = (int)(123.0 * ((double)index / (double)Math.max(this.models.size() - 7, 1)));
        this.scroll = Mth.m_14045_((int)this.scroll, (int)0, (int)123);
    }

    private String getBackpackModel() {
        String model;
        CompoundTag tag;
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)this.f_96541_.f_91074_);
        if (!stack.m_41619_() && (tag = stack.m_41784_()).m_128425_("BackpackModel", 8) && !(model = tag.m_128461_("BackpackModel")).isEmpty()) {
            return model;
        }
        return (String)Config.SERVER.backpack.defaultCosmetic.get();
    }

    private void setLocalBackpackModel(String model) {
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)this.f_96541_.f_91074_);
        if (!stack.m_41619_()) {
            stack.m_41784_().m_128359_("BackpackModel", model);
        }
    }

    private boolean getLocalBackpackProperty(ModelProperty property) {
        CompoundTag tag;
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)this.f_96541_.f_91074_);
        if (!stack.m_41619_() && (tag = stack.m_41784_()).m_128425_(property.getTagName(), 1)) {
            return tag.m_128471_(property.getTagName());
        }
        return property.getDefaultValue();
    }

    private void setLocalBackpackProperty(ModelProperty property, boolean value) {
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)this.f_96541_.f_91074_);
        if (!stack.m_41619_()) {
            stack.m_41784_().m_128379_(property.getTagName(), value);
        }
    }

    private void renderPlayer(int x, int y, int mouseX, int mouseY, Player player) {
        float scale = 70.0f;
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252880_((float)x, (float)y, 1050.0f);
        modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_252880_(0.0f, 0.0f, 1000.0f);
        matrixStack.m_252880_(0.0f, -15.0f, 0.0f);
        Quaternionf playerRotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraRotation = new Quaternionf();
        cameraRotation.mul((Quaternionfc)Axis.f_252495_.m_252977_(this.windowRotationY + (float)(this.windowGrabbed ? mouseY - this.mouseClickedY : 0)));
        cameraRotation.mul((Quaternionfc)Axis.f_252436_.m_252977_(this.windowRotationX + (float)(this.windowGrabbed ? mouseX - this.mouseClickedX : 0)));
        playerRotation.mul((Quaternionfc)cameraRotation);
        matrixStack.m_252781_(playerRotation);
        matrixStack.m_252880_(0.0f, (float)(-this.windowHeight / 2), 0.0f);
        matrixStack.m_85841_(scale, scale, scale);
        float origBodyRot = player.f_20883_;
        float origBodyRotOld = player.f_20884_;
        float origYaw = player.m_146908_();
        float origYawOld = player.f_19859_;
        float origPitch = player.m_146909_();
        float origPitchOld = player.f_19860_;
        float origHeadYawOld = player.f_20886_;
        float origHeadYaw = player.f_20885_;
        String origBackpackModel = this.getBackpackModel();
        boolean origShowEnchantmentGlint = this.getLocalBackpackProperty(ModelProperty.SHOW_GLINT);
        boolean origShowWithElytra = this.getLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA);
        boolean origShowEffects = this.getLocalBackpackProperty(ModelProperty.SHOW_EFFECTS);
        player.f_20883_ = 0.0f;
        player.f_20884_ = 0.0f;
        player.m_146922_(0.0f);
        player.f_19859_ = 0.0f;
        player.m_146926_(15.0f);
        player.f_19860_ = 15.0f;
        player.f_20885_ = player.m_146908_();
        player.f_20886_ = player.m_146908_();
        this.setLocalBackpackModel(this.displayBackpackModel);
        this.setLocalBackpackProperty(ModelProperty.SHOW_GLINT, this.displayShowEnchantmentGlint);
        this.setLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA, this.displayShowWithElytra);
        this.setLocalBackpackProperty(ModelProperty.SHOW_EFFECTS, this.displayShowEffects);
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        cameraRotation.conjugate();
        manager.m_114468_(false);
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> manager.m_114384_((Entity)player, 0.0, 0.0625, 0.35, 0.0f, 1.0f, matrixStack, (MultiBufferSource)source, 0xF000F0));
        source.m_109911_();
        manager.m_114468_(true);
        player.f_20883_ = origBodyRot;
        player.f_20884_ = origBodyRotOld;
        player.m_146922_(origYaw);
        player.f_19859_ = origYawOld;
        player.m_146926_(origPitch);
        player.f_19860_ = origPitchOld;
        player.f_20886_ = origHeadYawOld;
        player.f_20885_ = origHeadYaw;
        this.setLocalBackpackModel(origBackpackModel);
        this.setLocalBackpackProperty(ModelProperty.SHOW_GLINT, origShowEnchantmentGlint);
        this.setLocalBackpackProperty(ModelProperty.SHOW_WITH_ELYTRA, origShowWithElytra);
        this.setLocalBackpackProperty(ModelProperty.SHOW_EFFECTS, origShowEffects);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    private static class BackpackModelEntry {
        private final String id;
        private final Backpack backpack;
        private final Component label;
        private final List<FormattedCharSequence> unlockTooltip;

        public BackpackModelEntry(Backpack backpack, Map<ResourceLocation, Component> progressMap) {
            this.id = backpack.getId().toString();
            this.backpack = backpack;
            this.label = Component.m_237115_((String)backpack.getTranslationKey());
            MutableComponent unlockMessage = Component.m_237115_((String)(backpack.getTranslationKey() + ".unlock"));
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>(Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)unlockMessage, 150));
            list.add(0, Language.m_128107_().m_5536_((FormattedText)LOCKED));
            if (progressMap.containsKey(backpack.getId())) {
                MutableComponent component = progressMap.get(backpack.getId()).m_6879_().m_130940_(ChatFormatting.YELLOW);
                list.add(Language.m_128107_().m_5536_((FormattedText)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
        }

        public String getId() {
            return this.id;
        }

        public Component getLabel() {
            return this.label;
        }

        public List<FormattedCharSequence> getUnlockTooltip() {
            return this.unlockTooltip;
        }

        public Backpack getBackpack() {
            return this.backpack;
        }
    }
}

